local super = require "Object"

Inspector = super:new()

function Inspector:new(parameters)
    self = super.new(self)
    
    self.hooks = {}
    
    self.title = parameters.title
    self.undoTitle = parameters.undoTitle
    self.type = parameters.type
    self.iconName = parameters.icon
    self.target = parameters.target
    self.constraint = parameters.constraint
    
    return self
end

function Inspector:addHook(hook, name)
    name = name or 1
    if not hook then
        error("Can't add nonexistent hook \"" .. name .. "\" to inspector \"" .. (self.title or '') .. "\".")
    end
    if self.hooks[name] then
        error("Can't add more than one hook named \"" .. name .. "\" to inspector \"" .. (self.title or '') .. "\".")
    end
    self.hooks[name] = hook
    hook:addObserver(self)
end

function Inspector:getHook(hookName)
    return self.hooks[hookName or 1]
end

return Inspector
